<?php

namespace App\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\Routing\Annotation\Route;
use Symfony\Component\HttpFoundation\Request;
use App\Entity\Email;

class AppController extends AbstractController
{
    /**
     * @Route("/", name="app_homepage")
     */
    public function index(Request $request)
    {
        $em = $this->getDoctrine()->getManager();
        $emails = $em->getRepository(Email::class)->findAllSorted('inbox');
        
        return $this->render('app/index.html.twig', [
            'emails' => $emails,
        ]);
    }

    /**
     * @Route("/sent", name="app_sent")
     */
    public function sent(Request $request)
    {
        $em = $this->getDoctrine()->getManager();
        $emails = $em->getRepository(Email::class)->findAllSorted('sent');
        
        return $this->render('app/index.html.twig', [
            'emails' => $emails,
        ]);
    }

    /**
     * @Route("/trash", name="app_trash")
     */
    public function trash(Request $request)
    {
        $em = $this->getDoctrine()->getManager();
        $emails = $em->getRepository(Email::class)->findAllSorted('trash');
        
        return $this->render('app/index.html.twig', [
            'emails' => $emails,
        ]);
    }

    /**
     * @Route("/email/{id}", name="app_show_email", requirements={"id"="\d+"})
     */
    public function showEmail(Request $request, $id)
    {
        $em = $this->getDoctrine()->getManager();
        $email = $em->getRepository(Email::class)->find($id);

        return $this->render('app/email.html.twig', [
            'email' => $email,
        ]);
    }
}
