<?php

namespace App\DataFixtures;

use Doctrine\Bundle\FixturesBundle\Fixture;
use Doctrine\Common\Persistence\ObjectManager;
use App\Entity\User;
use Symfony\Component\Security\Core\Encoder\UserPasswordEncoderInterface;

class UserFixtures extends Fixture
{
    private $passwordEncoder;

    public function __construct(UserPasswordEncoderInterface $passwordEncoder)
    {
        $this->passwordEncoder = $passwordEncoder;
    }

    public function load(ObjectManager $manager)
    {
        $user1 = new User();
        $user1->setEmail('marlene.durand66@outlook.fr');
        $user1->setPassword($this->passwordEncoder->encodePassword($user1,'hermes66'));
        $manager->persist($user1);

        $user2 = new User();
        $user2->setEmail('jp.dubois73@outlook.com');
        $user2->setPassword($this->passwordEncoder->encodePassword($user2,'cecile9902'));
        $manager->persist($user2);

        $user3 = new User();
        $user3->setEmail('stan.nugaits@mucdonald.com');
        $user3->setPassword($this->passwordEncoder->encodePassword($user2,'Franck2007'));
        $manager->persist($user3);

        $user4 = new User();
        $user4->setEmail('jennifier.aufiche@mucdonald.com');
        $user4->setPassword($this->passwordEncoder->encodePassword($user2,'Bungabunga'));
        $manager->persist($user4);

        $user5 = new User();
        $user5->setEmail('madison.ribs@mucdonald.com');
        $user5->setPassword($this->passwordEncoder->encodePassword($user2,'Malia75'));
        $manager->persist($user4);

        $user6 = new User();
        $user6->setEmail('pat.ato@mucdonald.com');
        $user6->setPassword($this->passwordEncoder->encodePassword($user2,'Ashley56'));
        $manager->persist($user4);

        $manager->flush();
    }
}
